/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.window;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.util.RollingAverage;
import me.lucko.spark.proto.SparkProtos;

public class WindowStatisticsCollector {
    private static final SparkProtos.WindowStatistics ZERO = (SparkProtos.WindowStatistics)SparkProtos.WindowStatistics.newBuilder().build();
    private final SparkPlatform platform;
    private final Map<Integer, SparkProtos.WindowStatistics> stats;
    private TickCounter tickCounter;

    public WindowStatisticsCollector(SparkPlatform platform) {
        this.platform = platform;
        this.stats = new ConcurrentHashMap<Integer, SparkProtos.WindowStatistics>();
    }

    public void startCountingTicks(TickHook hook) {
        this.tickCounter = new NormalTickCounter(this.platform, hook);
    }

    public ExplicitTickCounter startCountingTicksExplicit(TickHook hook) {
        ExplicitTickCounter counter = new ExplicitTickCounter(this.platform, hook);
        this.tickCounter = counter;
        return counter;
    }

    public void stop() {
        if (this.tickCounter != null) {
            this.tickCounter.stop();
        }
    }

    public int getTotalTicks() {
        return this.tickCounter == null ? -1 : this.tickCounter.getTotalTicks();
    }

    public void measureNow(int window) {
        this.stats.computeIfAbsent(window, w -> this.measure());
    }

    public void ensureHasStatisticsForAllWindows(int[] windows) {
        for (int window : windows) {
            this.stats.computeIfAbsent(window, w -> ZERO);
        }
    }

    public Map<Integer, SparkProtos.WindowStatistics> export() {
        return this.stats;
    }

    private SparkProtos.WindowStatistics measure() {
        SparkProtos.WindowStatistics.Builder builder = SparkProtos.WindowStatistics.newBuilder();
        TickStatistics tickStatistics = this.platform.getTickStatistics();
        if (tickStatistics != null) {
            builder.setTps(tickStatistics.tps1Min());
            RollingAverage mspt = tickStatistics.duration1Min();
            if (mspt != null) {
                builder.setMsptMedian(mspt.median());
                builder.setMsptMax(mspt.max());
            }
        }
        if (this.tickCounter != null) {
            int ticks = this.tickCounter.getCountedTicksThisWindowAndReset();
            builder.setTicks(ticks);
        }
        builder.setCpuProcess(CpuMonitor.processLoad1MinAvg());
        builder.setCpuSystem(CpuMonitor.systemLoad1MinAvg());
        return (SparkProtos.WindowStatistics)builder.build();
    }

    public static final class NormalTickCounter
    extends BaseTickCounter {
        private int last;

        NormalTickCounter(SparkPlatform platform, TickHook tickHook) {
            super(platform, tickHook);
            this.last = this.tickHook.getCurrentTick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCountedTicksThisWindowAndReset() {
            NormalTickCounter normalTickCounter = this;
            synchronized (normalTickCounter) {
                int now = this.tickHook.getCurrentTick();
                int ticks = now - this.last;
                this.last = now;
                return ticks;
            }
        }
    }

    public static interface TickCounter {
        public void stop();

        public int getTotalTicks();

        public int getCountedTicksThisWindowAndReset();
    }

    public static final class ExplicitTickCounter
    extends BaseTickCounter {
        private final AtomicInteger counted = new AtomicInteger();
        private final AtomicInteger total = new AtomicInteger();

        ExplicitTickCounter(SparkPlatform platform, TickHook tickHook) {
            super(platform, tickHook);
        }

        public void increment() {
            this.counted.incrementAndGet();
            this.total.incrementAndGet();
        }

        public int getTotalCountedTicks() {
            return this.total.get();
        }

        @Override
        public int getCountedTicksThisWindowAndReset() {
            return this.counted.getAndSet(0);
        }
    }

    private static abstract class BaseTickCounter
    implements TickCounter {
        protected final SparkPlatform platform;
        protected final TickHook tickHook;
        private final int startTick;
        private int stopTick = -1;

        BaseTickCounter(SparkPlatform platform, TickHook tickHook) {
            this.platform = platform;
            this.tickHook = tickHook;
            this.startTick = this.tickHook.getCurrentTick();
        }

        @Override
        public void stop() {
            this.stopTick = this.tickHook.getCurrentTick();
        }

        @Override
        public int getTotalTicks() {
            if (this.startTick == -1) {
                throw new IllegalStateException("start tick not recorded");
            }
            if (this.stopTick == -1) {
                throw new IllegalStateException("stop tick not recorded");
            }
            return this.stopTick - this.startTick;
        }
    }
}

